"use client"

import { DropdownMenuItem } from "@/components/ui/dropdown-menu";
import { useRouter } from "@/lib/navigation.router";
import { cn } from "@/lib/utils";
import { signOut } from "aws-amplify/auth";
import { LogOut } from "lucide-react";

export function LogoutDropdownMenuItem({ className }: { className?: string }) {
  const router = useRouter();

  return (
    <DropdownMenuItem
      className={cn("flex flex-row gap-2 items-center w-full h-full", className)}
      onClick={async () => {
        await signOut()

        router.navigateAndReplaceHistory("/login")
      }}
    >
      <LogOut className="size-4" />
      Log out
    </DropdownMenuItem>
  )
}
